/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.gui;

import com.izforge.izpack.gui.TwoColumnConstraints;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.LayoutManager2;
import java.awt.Stroke;
import java.util.Vector;

public class TwoColumnLayout
implements LayoutManager2 {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int CENTER = 2;
    private Vector[] components = new Vector[]{new Vector(), new Vector()};
    private TwoColumnConstraints title = null;
    private int margin = 0;
    private int topBuffer = 0;
    private int indent = 0;
    private int gap = 5;
    private int alignment = 0;
    private int leftRule;
    private int rightRule;
    private int centerRule;
    private int titleHeight;

    public TwoColumnLayout(int n, int n2, int n3, int n4, int n5) {
        this.indent = n3;
        this.gap = n2;
        if (n >= 0 && n <= 50) {
            this.margin = n;
        }
        if (n4 >= 0 && n4 <= 100) {
            this.topBuffer = n4;
        }
        if (n5 == 0 || n5 == 2 || n5 == 1) {
            this.alignment = n5;
        }
    }

    public void addLayoutComponent(Component component, Object object) {
        if (object == null) {
            return;
        }
        TwoColumnConstraints twoColumnConstraints = null;
        try {
            twoColumnConstraints = (TwoColumnConstraints)object;
            twoColumnConstraints = (TwoColumnConstraints)twoColumnConstraints.clone();
        }
        catch (Throwable throwable) {
            return;
        }
        twoColumnConstraints.component = component;
        if (twoColumnConstraints.position == 9) {
            this.title = twoColumnConstraints;
            if (this.title.stretch) {
                this.title.align = 0;
            }
        } else if (twoColumnConstraints.position == 27) {
            if (this.components[0].size() < this.components[1].size()) {
                this.components[1].insertElementAt(null, this.components[0].size());
            }
            this.components[0].add(twoColumnConstraints);
            while (this.components[0].size() > this.components[1].size()) {
                this.components[1].add(null);
            }
        } else if (twoColumnConstraints.position == 15) {
            this.components[0].add(twoColumnConstraints);
        } else if (twoColumnConstraints.position == 26) {
            this.components[1].add(twoColumnConstraints);
        }
    }

    public void layoutContainer(Container container) {
        this.positionRules(container);
        this.positionTitle(container);
        this.positionComponents(container);
    }

    private void positionRules(Container container) {
        int n = this.margin(container);
        if (this.alignment == 0) {
            this.leftRule = n;
            this.centerRule = this.leftRule + this.minimumColumnWidth(0, container) + this.gap;
            this.rightRule = container.getWidth() - n;
        } else if (this.alignment == 2) {
            this.centerRule = (int)(container.getMinimumSize().getWidth() / 2.0);
            this.leftRule = this.centerRule - this.minimumColumnWidth(0, container) - this.gap;
            this.rightRule = container.getWidth() - n;
        } else if (this.alignment == 1) {
            this.rightRule = container.getWidth() - n;
            this.centerRule = this.rightRule - this.minimumColumnWidth(1, container);
            this.leftRule = this.centerRule - this.minimumColumnWidth(0, container) - this.gap;
        }
    }

    private void positionTitle(Container container) {
        if (this.title != null) {
            Component component = this.title.component;
            int n = (int)component.getMinimumSize().getWidth();
            this.titleHeight = (int)component.getMinimumSize().getHeight();
            if (component != null) {
                if (this.title.stretch) {
                    n = this.rightRule - this.leftRule;
                    component.setBounds(this.leftRule, 0, n, this.titleHeight);
                } else if (this.title.align == 31) {
                    component.setBounds(this.leftRule, 0, n, this.titleHeight);
                } else if (this.title.align == 35) {
                    int n2 = this.centerRule - n / 2;
                    component.setBounds(n2, 0, n, this.titleHeight);
                } else if (this.title.align == 47) {
                    int n3 = this.rightRule - n;
                    component.setBounds(n3, 0, n, this.titleHeight);
                }
            }
        }
    }

    private void positionComponents(Container container) {
        int n = this.titleHeight + this.minimumClusterHeight();
        int n2 = this.topBuffer(n, container);
        int n3 = 0;
        int n4 = 0;
        if (n2 < 0) {
            n2 = 0;
        }
        int n5 = this.titleHeight + n2;
        int n6 = 0;
        while (n6 < this.rows()) {
            int n7;
            n3 = this.height(n6, 0);
            if (n3 > (n4 = this.height(n6, 1))) {
                n7 = (n3 - n4) / 2;
                this.positionComponent(n5, n6, 0, container);
                this.positionComponent(n5 + n7, n6, 1, container);
                n5 += n3;
            } else if (n3 < n4) {
                n7 = (n4 - n3) / 2;
                this.positionComponent(n5 + n7, n6, 0, container);
                this.positionComponent(n5, n6, 1, container);
                n5 += n4;
            } else {
                this.positionComponent(n5, n6, 0, container);
                this.positionComponent(n5, n6, 1, container);
                n5 += n3;
            }
            ++n6;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void positionComponent(int var1_1, int var2_2, int var3_3, Container var4_4) {
        block11: {
            var5_5 = null;
            try {
                var5_5 = (TwoColumnConstraints)this.components[var3_3].elementAt(var2_2);
            }
            catch (Throwable var6_6) {
                return;
            }
            var6_7 = 0;
            if (var5_5 == null) break block11;
            var7_8 = var5_5.component;
            var8_9 = (int)var7_8.getPreferredSize().getWidth();
            var9_10 = (int)var7_8.getPreferredSize().getHeight();
            var6_7 = var3_3 == 0 ? this.leftRule : this.centerRule;
            if (var7_8 == null) break block11;
            if (!var5_5.stretch) ** GOTO lbl-1000
            if (var5_5.position == 27) {
                var8_9 = this.rightRule - this.leftRule;
                var6_7 = this.leftRule;
            } else if (var5_5.stretch && var3_3 == 0) {
                var8_9 = this.centerRule - this.leftRule;
            } else if (var5_5.stretch && var3_3 == 1) {
                var8_9 = this.rightRule - this.centerRule;
            } else if (var5_5.position == 27) {
                if (var8_9 > this.rightRule - this.leftRule) {
                    var8_9 = this.rightRule - this.leftRule;
                }
                var6_7 = this.leftRule;
            }
            if (var5_5.indent) {
                var8_9 -= this.indent;
                var6_7 += this.indent;
            }
            var7_8.setBounds(var6_7, var1_1, var8_9, var9_10);
        }
    }

    private int minimumColumnWidth(int n, Container container) {
        Component component = null;
        TwoColumnConstraints twoColumnConstraints = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.components[n].size()) {
            twoColumnConstraints = (TwoColumnConstraints)this.components[n].elementAt(n4);
            if (twoColumnConstraints != null) {
                if (twoColumnConstraints.position != 27) {
                    component = twoColumnConstraints.component;
                    n3 = (int)component.getMinimumSize().getWidth();
                    if (twoColumnConstraints.indent) {
                        n3 += this.indent;
                    }
                    if (n3 > n2) {
                        n2 = n3;
                    }
                }
            }
            ++n4;
        }
        return n2;
    }

    private int minimumBothColumnsWidth(Container container) {
        Component component = null;
        TwoColumnConstraints twoColumnConstraints = null;
        int n = 0;
        int n2 = 0;
        if (this.title != null) {
            component = this.title.component;
            n = (int)component.getMinimumSize().getWidth();
        }
        int n3 = 0;
        while (n3 < this.components[0].size()) {
            twoColumnConstraints = (TwoColumnConstraints)this.components[0].elementAt(n3);
            if (twoColumnConstraints != null) {
                if (twoColumnConstraints.position == 27) {
                    component = twoColumnConstraints.component;
                    n2 = (int)component.getMinimumSize().getWidth();
                    if (twoColumnConstraints.indent) {
                        n2 += this.indent;
                    }
                    if (n2 > n) {
                        n = n2;
                    }
                }
            }
            ++n3;
        }
        return n;
    }

    private int minimumClusterHeight() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.rows()) {
            n += this.rowHeight(n2);
            ++n2;
        }
        return n;
    }

    private int rows() {
        int n;
        int n2 = 0;
        int n3 = this.components[0].size();
        n2 = n3 > (n = this.components[1].size()) ? n3 : n;
        return n2;
    }

    private int rowHeight(int n) {
        int n2;
        int n3 = 0;
        int n4 = this.height(n, 0);
        n3 = n4 > (n2 = this.height(n, 1)) ? n4 : n2;
        return n3;
    }

    private int height(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        try {
            TwoColumnConstraints twoColumnConstraints = (TwoColumnConstraints)this.components[n2].elementAt(n);
            if (twoColumnConstraints != null) {
                Component component = twoColumnConstraints.component;
                n4 = (int)component.getMinimumSize().getWidth();
                n3 = (int)component.getMinimumSize().getHeight();
                if (twoColumnConstraints.position == 15) {
                    if (n4 > this.centerRule - this.leftRule) {
                        component.setBounds(0, 0, this.centerRule - this.leftRule, n3);
                    }
                } else if (twoColumnConstraints.position == 26) {
                    if (n4 > this.rightRule - this.centerRule) {
                        component.setBounds(0, 0, this.rightRule - this.centerRule, n3);
                    }
                } else if (twoColumnConstraints.position == 27 && n4 > this.rightRule - this.leftRule) {
                    component.setBounds(0, 0, this.rightRule - this.leftRule, n3);
                }
                n3 = (int)component.getMinimumSize().getHeight();
            }
        }
        catch (Throwable throwable) {}
        return n3;
    }

    private int margin(Container container) {
        int n = (int)(container.getSize().getWidth() * (double)this.margin / 100.0);
        return n;
    }

    private int reverseMargin(Container container) {
        int n;
        int n2 = this.minimumColumnWidth(0, container);
        int n3 = this.minimumColumnWidth(1, container);
        int n4 = this.minimumBothColumnsWidth(container);
        if (n4 > (n = n2 + n3)) {
            n = n4;
        }
        int n5 = n / (100 - 2 * this.margin) * this.margin;
        return n5;
    }

    private int topBuffer(int n, Container container) {
        int n2 = (int)container.getSize().getHeight() - n;
        n2 = n2 * this.topBuffer / 100;
        return n2;
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.minimumLayoutSize(container);
    }

    public Dimension minimumLayoutSize(Container container) {
        this.positionTitle(container);
        int n = this.minimumBothColumnsWidth(container);
        int n2 = this.minimumClusterHeight() + this.titleHeight;
        return new Dimension(n, n2);
    }

    public Dimension maximumLayoutSize(Container container) {
        return this.minimumLayoutSize(container);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.0f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.0f;
    }

    public void invalidateLayout(Container container) {
        this.leftRule = 0;
        this.rightRule = 0;
        this.centerRule = 0;
        this.titleHeight = 0;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public void showRules(Graphics2D graphics2D, Color color) {
        int n = graphics2D.getClipBounds().height;
        Stroke stroke = graphics2D.getStroke();
        Color color2 = graphics2D.getColor();
        BasicStroke basicStroke = new BasicStroke(1.0f, 0, 2, 1.5f, new float[]{10.0f, 5.0f}, 5.0f);
        graphics2D.setColor(color);
        graphics2D.drawLine(this.leftRule, 0, this.leftRule, n);
        graphics2D.drawLine(this.centerRule, this.titleHeight, this.centerRule, n);
        graphics2D.drawLine(this.rightRule, 0, this.rightRule, n);
        graphics2D.drawLine(this.leftRule, this.titleHeight, this.rightRule, this.titleHeight);
        graphics2D.setStroke(basicStroke);
        graphics2D.drawLine(this.leftRule + this.indent, this.titleHeight, this.leftRule + this.indent, n);
        graphics2D.drawLine(this.centerRule + this.indent, this.titleHeight, this.centerRule + this.indent, n);
        graphics2D.setStroke(stroke);
        graphics2D.setColor(color2);
    }
}

