/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.GUIPrefs;
import com.izforge.izpack.Info;
import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.IzPackMetalTheme;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.TreeMap;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import net.n3.nanoxml.NonValidator;
import net.n3.nanoxml.StdXMLBuilder;
import net.n3.nanoxml.StdXMLParser;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLElement;

public class Installer {
    private LocaleDatabase langpack;
    private InstallData installdata;
    private String lnf;

    public Installer() throws Exception {
        this.loadInstallData();
        this.checkJavaVersion();
        this.loadLookAndFeel();
        this.loadLangPack();
        this.loadGUI();
    }

    public Installer(File file) throws Exception {
        this.loadInstallData();
        this.loadXMLData(file);
        this.installdata.localeISO3 = this.installdata.xmlData.getAttribute("langpack");
        InputStream inputStream = this.getClass().getResourceAsStream("/langpacks/" + this.installdata.localeISO3 + ".xml");
        this.langpack = new LocaleDatabase(inputStream);
        InstallerFrame installerFrame = new InstallerFrame(this.langpack, this.installdata);
    }

    private void checkJavaVersion() throws Exception {
        String string;
        String string2 = System.getProperty("java.version");
        if (string2.compareTo(string = this.installdata.info.getJavaVersion()) < 0) {
            System.out.println("Can't install !");
            System.out.println("> The minimum Java version required is " + string);
            System.out.println("> Your version is " + string2);
            System.out.println("Please upgrade to the minimum version.");
            System.exit(1);
        }
    }

    private void loadXMLData(File file) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(file);
        StdXMLParser stdXMLParser = new StdXMLParser();
        stdXMLParser.setBuilder(new StdXMLBuilder());
        stdXMLParser.setReader(new StdXMLReader(fileInputStream));
        stdXMLParser.setValidator(new NonValidator());
        this.installdata.xmlData = (XMLElement)stdXMLParser.parse();
        fileInputStream.close();
    }

    private void loadLangPack() throws Exception {
        String string;
        Object object;
        ArrayList arrayList = this.getAvailableLangPacks();
        int n = arrayList.size();
        if (n == 0) {
            throw new Exception("no language pack available");
        }
        if (n != 1) {
            object = new LanguageDialog(arrayList.toArray());
            ((LanguageDialog)object).setSelection(Locale.getDefault().getISO3Country().toLowerCase());
            ((Dialog)object).setModal(true);
            ((Dialog)object).show();
            string = (String)((LanguageDialog)object).getSelection();
            if (string == null) {
                throw new Exception("installation canceled");
            }
        } else {
            string = (String)arrayList.get(0);
        }
        this.installdata.xmlData.setAttribute("langpack", string);
        this.installdata.localeISO3 = string;
        object = this.getClass().getResourceAsStream("/langpacks/" + string + ".xml");
        this.langpack = new LocaleDatabase((InputStream)object);
    }

    private ArrayList getAvailableLangPacks() throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        InputStream inputStream = this.getClass().getResourceAsStream("/langpacks.info");
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int n = dataInputStream.readInt();
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(dataInputStream.readUTF());
            ++n2;
        }
        dataInputStream.close();
        return arrayList;
    }

    private void loadInstallData() throws Exception {
        ObjectInputStream objectInputStream;
        Properties properties = null;
        InputStream inputStream = this.getClass().getResourceAsStream("/vars");
        if (null != inputStream) {
            objectInputStream = new ObjectInputStream(inputStream);
            properties = (Properties)objectInputStream.readObject();
            objectInputStream.close();
        }
        inputStream = this.getClass().getResourceAsStream("/info");
        objectInputStream = new ObjectInputStream(inputStream);
        Info info = (Info)objectInputStream.readObject();
        objectInputStream.close();
        inputStream = this.getClass().getResourceAsStream("/GUIPrefs");
        objectInputStream = new ObjectInputStream(inputStream);
        GUIPrefs gUIPrefs = (GUIPrefs)objectInputStream.readObject();
        objectInputStream.close();
        inputStream = this.getClass().getResourceAsStream("/panelsOrder");
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int n = dataInputStream.readInt();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(dataInputStream.readUTF());
            ++n2;
        }
        dataInputStream.close();
        inputStream = this.getClass().getResourceAsStream("/packs.info");
        objectInputStream = new ObjectInputStream(inputStream);
        n = objectInputStream.readInt();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        n2 = 0;
        while (n2 < n) {
            arrayList2.add(objectInputStream.readObject());
            ++n2;
        }
        objectInputStream.close();
        String string = System.getProperty("os.name");
        String string2 = System.getProperty("user.name");
        String string3 = string.regionMatches(true, 0, "windows", 0, 7) ? System.getProperty("user.home").substring(0, 3) + "Program Files" + File.separator : (string.regionMatches(true, 0, "mac os x", 0, 6) ? "/Applications" + File.separator : (string.regionMatches(true, 0, "mac", 0, 3) ? "" : (string2.equals("root") ? "/usr/local" + File.separator : System.getProperty("user.home") + File.separator)));
        String string4 = string3 + info.getAppName();
        inputStream = this.getClass().getResourceAsStream("/kind");
        dataInputStream = new DataInputStream(inputStream);
        String string5 = dataInputStream.readUTF();
        dataInputStream.close();
        this.installdata = InstallData.getInstance();
        this.installdata.setInstallPath(string4);
        this.installdata.setVariable("JAVA_HOME", System.getProperty("java.home"));
        this.installdata.setVariable("USER_HOME", System.getProperty("user.home"));
        this.installdata.setVariable("USER_NAME", System.getProperty("user.name"));
        this.installdata.setVariable("FILE_SEPARATOR", File.separator);
        if (null != properties) {
            Enumeration<Object> enumeration = properties.keys();
            String string6 = null;
            String string7 = null;
            while (enumeration.hasMoreElements()) {
                string6 = (String)enumeration.nextElement();
                string7 = properties.getProperty(string6);
                this.installdata.setVariable(string6, string7);
            }
        }
        this.installdata.guiPrefs = gUIPrefs;
        this.installdata.info = info;
        this.installdata.kind = string5;
        this.installdata.panelsOrder = arrayList;
        this.installdata.availablePacks = arrayList2;
        this.installdata.selectedPacks = (ArrayList)arrayList2.clone();
    }

    private void loadLookAndFeel() throws Exception {
        if (this.installdata.kind.equalsIgnoreCase("standard") || this.installdata.kind.equalsIgnoreCase("web")) {
            if (UIManager.getLookAndFeel() instanceof MetalLookAndFeel) {
                MetalLookAndFeel.setCurrentTheme(new IzPackMetalTheme());
                ButtonFactory.useButtonIcons();
            }
            this.lnf = "swing";
        } else if (this.installdata.kind.equalsIgnoreCase("standard-kunststoff") || this.installdata.kind.equalsIgnoreCase("web-kunststoff")) {
            ButtonFactory.useHighlightButtons();
            this.installdata.buttonsHColor = new Color(255, 255, 255);
            Class<?> clazz = Class.forName("com.incors.plaf.kunststoff.KunststoffLookAndFeel");
            Class<?> clazz2 = Class.forName("javax.swing.plaf.metal.MetalTheme");
            Class[] classArray = new Class[]{clazz2};
            Class<?> clazz3 = Class.forName("com.izforge.izpack.gui.IzPackKMetalTheme");
            Method method = clazz.getMethod("setCurrentTheme", classArray);
            LookAndFeel lookAndFeel = (LookAndFeel)clazz.newInstance();
            MetalTheme metalTheme = (MetalTheme)clazz3.newInstance();
            Object[] objectArray = new Object[]{metalTheme};
            UIManager.setLookAndFeel(lookAndFeel);
            method.invoke((Object)lookAndFeel, objectArray);
            this.lnf = "kunststoff";
        }
    }

    private void loadGUI() throws Exception {
        UIManager.put("OptionPane.yesButtonText", this.langpack.getString("installer.yes"));
        UIManager.put("OptionPane.noButtonText", this.langpack.getString("installer.no"));
        UIManager.put("OptionPane.cancelButtonText", this.langpack.getString("installer.cancel"));
        String string = this.langpack.getString("installer.title") + this.installdata.info.getAppName();
        InstallerFrame installerFrame = new InstallerFrame(string, this.langpack, this.installdata);
    }

    public static void main(String[] stringArray) {
        block3: {
            try {
                int n = stringArray.length;
                if (n == 0) {
                    Installer installer = new Installer();
                    break block3;
                }
                Installer installer = new Installer(new File(stringArray[0]));
            }
            catch (Exception exception) {
                System.err.println("- Error -");
                System.err.println(exception.toString());
                exception.printStackTrace();
                System.exit(0);
            }
        }
    }

    class FlagRenderer
    extends JLabel
    implements ListCellRenderer {
        private TreeMap icons = new TreeMap();
        private TreeMap grayIcons = new TreeMap();

        FlagRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (n == -1) {
                bl = true;
            }
            String string = (String)object;
            this.setText(string);
            if (bl) {
                if (Installer.this.lnf.equalsIgnoreCase("swing")) {
                    this.setOpaque(true);
                } else if (n == -1) {
                    this.setOpaque(false);
                } else {
                    this.setOpaque(true);
                }
                this.setForeground(jList.getSelectionForeground());
                this.setBackground(jList.getSelectionBackground());
            } else {
                this.setOpaque(false);
            }
            if (!this.icons.containsKey(string)) {
                ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/res/flag." + string));
                this.icons.put(string, imageIcon);
                this.grayIcons.put(string, new ImageIcon(GrayFilter.createDisabledImage(imageIcon.getImage())));
            }
            if (bl) {
                this.setIcon((ImageIcon)this.icons.get(string));
            } else {
                this.setIcon((ImageIcon)this.grayIcons.get(string));
            }
            return this;
        }
    }

    class LanguageDialog
    extends JDialog
    implements ActionListener {
        private JComboBox comboBox;
        private JButton okButton;

        public LanguageDialog(Object[] objectArray) {
            try {
                Installer.this.loadLookAndFeel();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.addWindowListener(new WindowHandler());
            JPanel jPanel = (JPanel)this.getContentPane();
            this.setTitle("Language selection");
            GridBagLayout gridBagLayout = new GridBagLayout();
            jPanel.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 10;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            ImageIcon imageIcon = this.getImage();
            JLabel jLabel = new JLabel(imageIcon);
            gridBagConstraints.gridy = 0;
            jPanel.add(jLabel);
            gridBagConstraints.fill = 2;
            JLabel jLabel2 = new JLabel("Please select your language (ISO3 code)", 0);
            gridBagConstraints.gridy = 1;
            gridBagConstraints.insets = new Insets(5, 5, 0, 5);
            gridBagLayout.addLayoutComponent(jLabel2, gridBagConstraints);
            jPanel.add(jLabel2);
            JLabel jLabel3 = new JLabel("for install instructions:", 0);
            gridBagConstraints.gridy = 2;
            gridBagConstraints.insets = new Insets(0, 5, 5, 5);
            gridBagLayout.addLayoutComponent(jLabel3, gridBagConstraints);
            jPanel.add(jLabel3);
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            this.comboBox = new JComboBox<Object>(objectArray);
            this.comboBox.setRenderer(new FlagRenderer());
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridy = 3;
            gridBagLayout.addLayoutComponent(this.comboBox, gridBagConstraints);
            jPanel.add(this.comboBox);
            this.okButton = new JButton("Ok");
            this.okButton.addActionListener(this);
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.anchor = 10;
            gridBagLayout.addLayoutComponent(this.okButton, gridBagConstraints);
            jPanel.add(this.okButton);
            if (System.getProperty("mrj.version") == null) {
                this.pack();
            } else {
                this.setSize(this.getPreferredSize());
            }
            Dimension dimension = this.getSize();
            Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2 - 10);
            this.setResizable(true);
        }

        public ImageIcon getImage() {
            ImageIcon imageIcon;
            try {
                imageIcon = new ImageIcon(this.getClass().getResource("/res/installer.langsel.img"));
            }
            catch (NullPointerException nullPointerException) {
                imageIcon = null;
            }
            return imageIcon;
        }

        public Object getSelection() {
            return this.comboBox.getSelectedItem();
        }

        public void setSelection(Object object) {
            this.comboBox.setSelectedItem(object);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.dispose();
        }

        class WindowHandler
        extends WindowAdapter {
            WindowHandler() {
            }

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        }
    }
}

