/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.EtchedLineBorder;
import com.izforge.izpack.gui.IconsDatabase;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallListener;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.installer.UninstallData;
import com.izforge.izpack.installer.Unpacker;
import com.izforge.izpack.util.Housekeeper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.n3.nanoxml.NonValidator;
import net.n3.nanoxml.StdXMLBuilder;
import net.n3.nanoxml.StdXMLParser;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLElement;
import net.n3.nanoxml.XMLWriter;

public class InstallerFrame
extends JFrame {
    public LocaleDatabase langpack;
    private InstallData installdata;
    public IconsDatabase icons;
    private JPanel panelsContainer;
    private JPanel contentPane;
    private JButton prevButton;
    private JButton nextButton;
    private JButton quitButton;
    private JLabel madewithLabel;

    public InstallerFrame(String string, LocaleDatabase localeDatabase, InstallData installData) throws Exception {
        super(string);
        this.langpack = localeDatabase;
        this.installdata = installData;
        this.addWindowListener(new WindowHandler());
        this.loadIcons();
        this.loadPanels();
        this.buildGUI();
        this.showFrame();
        this.switchPanel(0);
    }

    public InstallerFrame(LocaleDatabase localeDatabase, InstallData installData) throws Exception {
        super("IzPack - automated installation");
        this.langpack = localeDatabase;
        this.installdata = installData;
        this.loadIcons();
        this.loadPanels();
        this.buildGUI();
        this.switchPanel(0);
        this.runAutomation();
        Housekeeper.getInstance().shutDown(0);
    }

    private void runAutomation() throws Exception {
        System.out.println("[ Running automated installation ... ]");
        int n = this.installdata.panels.size();
        int n2 = 0;
        while (n2 < n) {
            IzPanel izPanel = (IzPanel)this.installdata.panels.get(n2);
            String string = (String)this.installdata.panelsOrder.get(n2);
            XMLElement xMLElement = this.installdata.xmlData.getFirstChildNamed(string);
            izPanel.runAutomated(xMLElement);
            ++n2;
        }
        System.out.println("[ Automated installation done ]");
    }

    private void loadPanels() throws Exception {
        List list = this.installdata.panelsOrder;
        int n = list.size();
        Class[] classArray = new Class[]{Class.forName("com.izforge.izpack.installer.InstallerFrame"), Class.forName("com.izforge.izpack.installer.InstallData")};
        Object[] objectArray = new Object[]{this, this.installdata};
        int n2 = 0;
        while (n2 < n) {
            String string = (String)list.get(n2);
            Class<?> clazz = Class.forName("com.izforge.izpack.panels." + string);
            Constructor<?> constructor = clazz.getDeclaredConstructor(classArray);
            Object obj = constructor.newInstance(objectArray);
            IzPanel izPanel = (IzPanel)obj;
            this.installdata.panels.add(izPanel);
            XMLElement xMLElement = new XMLElement(string);
            this.installdata.xmlData.addChild(xMLElement);
            ++n2;
        }
    }

    private void loadIcons() throws Exception {
        this.icons = new IconsDatabase();
        InputStream inputStream = this.getClass().getResourceAsStream("/com/izforge/izpack/installer/icons.xml");
        StdXMLParser stdXMLParser = new StdXMLParser();
        stdXMLParser.setBuilder(new StdXMLBuilder());
        stdXMLParser.setReader(new StdXMLReader(inputStream));
        stdXMLParser.setValidator(new NonValidator());
        XMLElement xMLElement = (XMLElement)stdXMLParser.parse();
        Vector vector = xMLElement.getChildren();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            XMLElement xMLElement2 = (XMLElement)vector.get(n2);
            URL uRL = this.getClass().getResource(xMLElement2.getAttribute("res"));
            ImageIcon imageIcon = new ImageIcon(uRL);
            this.icons.put(xMLElement2.getAttribute("id"), imageIcon);
            ++n2;
        }
    }

    private void buildGUI() {
        this.setIconImage(this.icons.getImageIcon("JFrameIcon").getImage());
        JPanel jPanel = (JPanel)this.getGlassPane();
        jPanel.addMouseListener(new MouseAdapter(){});
        jPanel.addMouseMotionListener(new MouseMotionAdapter(){});
        jPanel.addKeyListener(new KeyAdapter(){});
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(new BorderLayout());
        this.panelsContainer = new JPanel();
        this.panelsContainer.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        this.panelsContainer.setLayout(new GridLayout(1, 1));
        this.contentPane.add((Component)this.panelsContainer, "Center");
        this.installdata.curPanelNumber = 0;
        IzPanel izPanel = (IzPanel)this.installdata.panels.get(0);
        this.panelsContainer.add(izPanel);
        NavigationHandler navigationHandler = new NavigationHandler();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8), BorderFactory.createTitledBorder(new EtchedLineBorder(), this.langpack.getString("installer.madewith") + " ")));
        jPanel2.add(Box.createHorizontalGlue());
        this.prevButton = ButtonFactory.createButton(this.langpack.getString("installer.prev"), this.icons.getImageIcon("stepback"), this.installdata.buttonsHColor);
        jPanel2.add(this.prevButton);
        this.prevButton.addActionListener(navigationHandler);
        jPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
        this.nextButton = ButtonFactory.createButton(this.langpack.getString("installer.next"), this.icons.getImageIcon("stepforward"), this.installdata.buttonsHColor);
        jPanel2.add(this.nextButton);
        this.nextButton.addActionListener(navigationHandler);
        jPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
        this.quitButton = ButtonFactory.createButton(this.langpack.getString("installer.quit"), this.icons.getImageIcon("stop"), this.installdata.buttonsHColor);
        jPanel2.add(this.quitButton);
        this.quitButton.addActionListener(navigationHandler);
        this.contentPane.add((Component)jPanel2, "South");
        try {
            ResourceManager resourceManager = new ResourceManager(this.installdata);
            ImageIcon imageIcon = resourceManager.getImageIconResource("Installer.image");
            if (imageIcon != null) {
                JPanel jPanel3 = new JPanel();
                jPanel3.setLayout(new BorderLayout());
                jPanel3.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 0));
                JLabel jLabel = new JLabel(imageIcon);
                jLabel.setBorder(BorderFactory.createLoweredBevelBorder());
                jPanel3.add((Component)jLabel, "Center");
                this.contentPane.add((Component)jPanel3, "West");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getRootPane().setDefaultButton(this.nextButton);
    }

    private void showFrame() {
        this.pack();
        this.setSize(this.installdata.guiPrefs.width, this.installdata.guiPrefs.height);
        this.setResizable(this.installdata.guiPrefs.resizable);
        this.centerFrame(this);
        this.setVisible(true);
    }

    private void switchPanel(int n) {
        this.panelsContainer.setVisible(false);
        IzPanel izPanel = (IzPanel)this.installdata.panels.get(this.installdata.curPanelNumber);
        IzPanel izPanel2 = (IzPanel)this.installdata.panels.get(n);
        izPanel2.makeXMLData(this.installdata.xmlData.getChildAtIndex(n));
        this.panelsContainer.remove(izPanel2);
        this.panelsContainer.add(izPanel);
        if (this.installdata.curPanelNumber == 0) {
            this.prevButton.setVisible(false);
            this.lockPrevButton();
            this.unlockNextButton();
        } else if (this.installdata.curPanelNumber == this.installdata.panels.size() - 1) {
            this.prevButton.setVisible(false);
            this.nextButton.setVisible(false);
            this.lockNextButton();
        } else {
            this.prevButton.setVisible(true);
            this.nextButton.setVisible(true);
            this.unlockPrevButton();
            this.unlockNextButton();
        }
        izPanel2.panelDeactivate();
        izPanel.panelActivate();
        this.panelsContainer.setVisible(true);
    }

    private void writeUninstallData() {
        try {
            UninstallData uninstallData = UninstallData.getInstance();
            ArrayList arrayList = uninstallData.getFilesList();
            ZipOutputStream zipOutputStream = this.installdata.uninstallOutJar;
            zipOutputStream.putNextEntry(new ZipEntry("install.log"));
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(zipOutputStream));
            int n = arrayList.size();
            int n2 = n - 1;
            bufferedWriter.write(this.installdata.getInstallPath());
            bufferedWriter.newLine();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                bufferedWriter.write((String)iterator.next());
                if (!iterator.hasNext()) continue;
                bufferedWriter.newLine();
            }
            bufferedWriter.flush();
            zipOutputStream.closeEntry();
            zipOutputStream.putNextEntry(new ZipEntry("jarlocation.log"));
            bufferedWriter.write(uninstallData.getUninstallerJarFilename());
            bufferedWriter.newLine();
            bufferedWriter.write(uninstallData.getUninstallerPath());
            bufferedWriter.flush();
            zipOutputStream.closeEntry();
            zipOutputStream.flush();
            zipOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public InputStream getResource(String string) throws Exception {
        return this.getClass().getResourceAsStream("/res/" + string);
    }

    public void centerFrame(Window window) {
        Dimension dimension = window.getSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        window.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2 - 10);
    }

    public Dimension getPanelsContainerSize() {
        return this.panelsContainer.getSize();
    }

    public void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, double d, double d2) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
    }

    public void exit() {
        if (this.installdata.canClose) {
            this.writeUninstallData();
            Housekeeper.getInstance().shutDown(0);
        } else {
            int n = JOptionPane.showConfirmDialog(this, this.langpack.getString("installer.quit.message"), this.langpack.getString("installer.quit.title"), 0);
            if (n == 0) {
                this.wipeAborted();
                Housekeeper.getInstance().shutDown(0);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void wipeAborted() {
        var2_1 = Unpacker.getRunningInstances();
        var1_2 = var2_1.iterator();
        while (var1_2.hasNext()) {
            var3_3 = (Thread)var1_2.next();
            var3_3.interrupt();
            try {
                Thread.sleep(3000L, 0);
            }
            catch (Exception var4_4) {
                // empty catch block
            }
        }
        var3_3 = UninstallData.getInstance();
        var1_2 = var3_3.getFilesList().iterator();
        if (var1_2.hasNext()) ** GOTO lbl20
        return;
lbl-1000:
        // 1 sources

        {
            var4_5 = (String)var1_2.next();
            var5_6 = new File(var4_5);
            var5_6.delete();
lbl20:
            // 2 sources

            ** while (var1_2.hasNext())
        }
lbl21:
        // 1 sources

        this.cleanWipe(new File(InstallData.getInstance().getInstallPath()));
    }

    private void cleanWipe(File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                this.cleanWipe(fileArray[n2]);
                ++n2;
            }
        }
        file.delete();
    }

    public void install(InstallListener installListener) {
        Unpacker unpacker = new Unpacker(this.installdata, installListener);
        unpacker.start();
    }

    public void writeXMLTree(XMLElement xMLElement, OutputStream outputStream) throws Exception {
        XMLWriter xMLWriter = new XMLWriter(outputStream);
        xMLWriter.write(xMLElement);
    }

    public void blockGUI() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.getGlassPane().setVisible(true);
        this.getGlassPane().setEnabled(true);
    }

    public void releaseGUI() {
        this.getGlassPane().setEnabled(false);
        this.getGlassPane().setVisible(false);
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void lockPrevButton() {
        this.prevButton.setEnabled(false);
    }

    public void lockNextButton() {
        this.nextButton.setEnabled(false);
    }

    public void unlockPrevButton() {
        this.prevButton.setEnabled(true);
    }

    public void unlockNextButton() {
        this.nextButton.setEnabled(true);
    }

    public void skipPanel() {
        if (this.installdata.curPanelNumber < this.installdata.panels.size() - 1) {
            ++this.installdata.curPanelNumber;
            this.switchPanel(this.installdata.curPanelNumber - 1);
        }
    }

    class WindowHandler
    extends WindowAdapter {
        WindowHandler() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            if (!((InstallerFrame)InstallerFrame.this).installdata.canClose) {
                JOptionPane.showMessageDialog(null, InstallerFrame.this.langpack.getString("installer.quit.message"), InstallerFrame.this.langpack.getString("installer.warning"), 0);
            }
            InstallerFrame.this.wipeAborted();
            Housekeeper.getInstance().shutDown(0);
        }
    }

    class NavigationHandler
    implements ActionListener {
        NavigationHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == InstallerFrame.this.prevButton) {
                if (((InstallerFrame)InstallerFrame.this).installdata.curPanelNumber > 0) {
                    --((InstallerFrame)InstallerFrame.this).installdata.curPanelNumber;
                    InstallerFrame.this.switchPanel(((InstallerFrame)InstallerFrame.this).installdata.curPanelNumber + 1);
                }
            } else if (object == InstallerFrame.this.nextButton) {
                if (((InstallerFrame)InstallerFrame.this).installdata.curPanelNumber < ((InstallerFrame)InstallerFrame.this).installdata.panels.size() - 1 && ((IzPanel)((InstallerFrame)InstallerFrame.this).installdata.panels.get(((InstallerFrame)InstallerFrame.this).installdata.curPanelNumber)).isValidated()) {
                    ++((InstallerFrame)InstallerFrame.this).installdata.curPanelNumber;
                    InstallerFrame.this.switchPanel(((InstallerFrame)InstallerFrame.this).installdata.curPanelNumber - 1);
                }
            } else if (object == InstallerFrame.this.quitButton) {
                InstallerFrame.this.exit();
            }
        }
    }
}

