/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.ResourceNotFoundException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.ImageIcon;

public class ResourceManager {
    private String locale = "";
    private final String resourceBasePath = "/res/";
    private InstallData installData;

    public ResourceManager(InstallData installData) {
        this.installData = installData;
        this.locale = this.installData.xmlData.getAttribute("langpack", "eng");
    }

    private String getLanguageResourceString(String string) throws ResourceNotFoundException {
        String string2 = "/res/" + string + "_" + this.locale;
        InputStream inputStream = this.getClass().getResourceAsStream(string2);
        if (inputStream != null) {
            return string2;
        }
        string2 = "/res/" + string;
        inputStream = this.getClass().getResourceAsStream(string2);
        if (inputStream != null) {
            return string2;
        }
        throw new ResourceNotFoundException("Can not find Resource " + string + " for language " + this.locale);
    }

    public InputStream getInputStream(String string) throws ResourceNotFoundException {
        return this.getClass().getResourceAsStream(this.getLanguageResourceString(string));
    }

    public URL getURL(String string) throws ResourceNotFoundException {
        try {
            return this.getClass().getResource(this.getLanguageResourceString(string + "_" + this.installData.localeISO3));
        }
        catch (Exception exception) {
            return this.getClass().getResource(this.getLanguageResourceString(string));
        }
    }

    public String getTextResource(String string) throws ResourceNotFoundException, IOException {
        int n;
        InputStream inputStream = null;
        try {
            inputStream = this.getInputStream(string + "_" + this.installData.localeISO3);
        }
        catch (Exception exception) {
            inputStream = this.getInputStream(string);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[5120];
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toString();
    }

    public ImageIcon getImageIconResource(String string) throws ResourceNotFoundException, IOException {
        return new ImageIcon(this.getURL(string));
    }

    public void setLocale(String string) {
        this.locale = string;
    }

    public String getLocale() {
        return this.locale;
    }
}

