/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.ExecutableFile;
import com.izforge.izpack.Pack;
import com.izforge.izpack.PackFile;
import com.izforge.izpack.ParsableFile;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallListener;
import com.izforge.izpack.installer.ScriptParser;
import com.izforge.izpack.installer.UninstallData;
import com.izforge.izpack.installer.VariableSubstitutor;
import com.izforge.izpack.util.FileExecutor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.JOptionPane;

public class Unpacker
extends Thread {
    private InstallData idata;
    private InstallListener listener;
    private UninstallData udata;
    private String jarLocation;
    private VariableSubstitutor vs;
    private static ArrayList instances = new ArrayList();

    public Unpacker(InstallData installData, InstallListener installListener) {
        super("IzPack - Unpacker thread");
        this.idata = installData;
        this.listener = installListener;
        this.vs = new VariableSubstitutor(installData.getVariableValueMap());
    }

    public static ArrayList getRunningInstances() {
        return instances;
    }

    public void run() {
        instances.add(this);
        try {
            Object object;
            Object object2;
            this.listener.startUnpack();
            String string = System.getProperty("os.name").toLowerCase();
            FileOutputStream fileOutputStream = null;
            ArrayList<Serializable> arrayList = new ArrayList<Serializable>();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            List list = this.idata.selectedPacks;
            int n = list.size();
            this.udata = UninstallData.getInstance();
            if (this.idata.kind.equalsIgnoreCase("web") || this.idata.kind.equalsIgnoreCase("web-kunststoff")) {
                InputStream inputStream = this.getClass().getResourceAsStream("/res/WebInstallers.url");
                object2 = new BufferedReader(new InputStreamReader(inputStream));
                this.jarLocation = ((BufferedReader)object2).readLine();
            }
            int n2 = 0;
            while (n2 < n) {
                Object object3;
                Serializable serializable;
                int n3 = this.idata.availablePacks.indexOf(list.get(n2));
                object = new ObjectInputStream(this.getPackAsStream(n3));
                int n4 = ((ObjectInputStream)object).readInt();
                this.listener.changeUnpack(0, n4, ((Pack)list.get((int)n2)).name);
                int n5 = 0;
                while (n5 < n4) {
                    PackFile packFile = (PackFile)((ObjectInputStream)object).readObject();
                    if (null == packFile.os || string.indexOf(packFile.os.toLowerCase()) > -1) {
                        String string2 = this.translatePath(packFile.targetPath);
                        serializable = new File(string2);
                        object3 = ((File)serializable).getName();
                        int n6 = ((String)object3).length();
                        File file = ((File)serializable).getParentFile();
                        if (!file.exists()) {
                            file.mkdirs();
                        }
                        this.udata.addFile(string2);
                        this.listener.progressUnpack(n5, string2);
                        if (!packFile.override && ((File)serializable).exists()) {
                            ((InputStream)object).skip(packFile.length);
                        } else {
                            fileOutputStream = new FileOutputStream(string2);
                            byte[] byArray = new byte[5120];
                            long l = 0L;
                            while (l < packFile.length) {
                                int n7 = packFile.length - l < (long)byArray.length ? (int)(packFile.length - l) : byArray.length;
                                int n8 = ((ObjectInputStream)object).read(byArray, 0, n7);
                                if (n8 == -1) {
                                    throw new IOException("Unexpected end of stream");
                                }
                                fileOutputStream.write(byArray, 0, n8);
                                l += (long)n8;
                            }
                            fileOutputStream.close();
                            String string3 = ((File)serializable).getName();
                            if (string3.startsWith("izpack-keepme") && string3.endsWith(".tmp")) {
                                ((File)serializable).delete();
                            }
                        }
                    } else {
                        ((InputStream)object).skip(packFile.length);
                    }
                    ++n5;
                }
                int n9 = ((ObjectInputStream)object).readInt();
                int n10 = 0;
                while (n10 < n9) {
                    serializable = (ParsableFile)((ObjectInputStream)object).readObject();
                    ((ParsableFile)serializable).path = this.translatePath(((ParsableFile)serializable).path);
                    arrayList.add(serializable);
                    ++n10;
                }
                int n11 = ((ObjectInputStream)object).readInt();
                n10 = 0;
                while (n10 < n11) {
                    object3 = (ExecutableFile)((ObjectInputStream)object).readObject();
                    ((ExecutableFile)object3).path = this.translatePath(((ExecutableFile)object3).path);
                    if (null != ((ExecutableFile)object3).argList && !((ExecutableFile)object3).argList.isEmpty()) {
                        String string4 = null;
                        int n12 = 0;
                        while (n12 < ((ExecutableFile)object3).argList.size()) {
                            string4 = (String)((ExecutableFile)object3).argList.get(n12);
                            string4 = this.translatePath(string4);
                            ((ExecutableFile)object3).argList.set(n12, string4);
                            ++n12;
                        }
                    }
                    arrayList2.add(object3);
                    ++n10;
                }
                ((ObjectInputStream)object).close();
                ++n2;
            }
            object2 = new ScriptParser(arrayList, this.vs);
            ((ScriptParser)object2).parseFiles();
            object = new FileExecutor(arrayList2);
            if (((FileExecutor)object).executeFiles() != 0) {
                JOptionPane.showMessageDialog(null, "The installation was not completed.", "Installation warning", 2);
            }
            this.putUninstaller();
            this.listener.stopUnpack();
        }
        catch (Exception exception) {
            this.listener.stopUnpack();
            this.listener.errorUnpack(exception.toString());
        }
        instances.remove(instances.indexOf(this));
    }

    private void putUninstaller() throws Exception {
        int n;
        ZipOutputStream zipOutputStream;
        String string = this.translatePath("$INSTALL_PATH") + File.separator + "Uninstaller";
        String string2 = string + File.separator + "uninstaller.jar";
        File file = new File(string);
        file.mkdirs();
        UninstallData uninstallData = UninstallData.getInstance();
        uninstallData.setUninstallerJarFilename(string2);
        uninstallData.setUninstallerPath(string);
        FileOutputStream fileOutputStream = new FileOutputStream(string2);
        this.idata.uninstallOutJar = zipOutputStream = new ZipOutputStream(fileOutputStream);
        zipOutputStream.setLevel(9);
        uninstallData.addFile(string2);
        InputStream inputStream = this.getClass().getResourceAsStream("/res/IzPack.uninstaller");
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null) {
            zipOutputStream.putNextEntry(new ZipEntry(zipEntry.getName()));
            n = zipInputStream.read();
            while (n != -1) {
                zipOutputStream.write(n);
                n = zipInputStream.read();
            }
            zipInputStream.closeEntry();
            zipOutputStream.closeEntry();
            zipEntry = zipInputStream.getNextEntry();
        }
        zipInputStream.close();
        inputStream = this.getClass().getResourceAsStream("/langpacks/" + this.idata.localeISO3 + ".xml");
        zipOutputStream.putNextEntry(new ZipEntry("langpack.xml"));
        n = inputStream.read();
        while (n != -1) {
            zipOutputStream.write(n);
            n = inputStream.read();
        }
        zipOutputStream.closeEntry();
    }

    private InputStream getPackAsStream(int n) throws Exception {
        InputStream inputStream = null;
        if (this.idata.kind.equalsIgnoreCase("standard") || this.idata.kind.equalsIgnoreCase("standard-kunststoff")) {
            inputStream = this.getClass().getResourceAsStream("/packs/pack" + n);
        } else if (this.idata.kind.equalsIgnoreCase("web") || this.idata.kind.equalsIgnoreCase("web-kunststoff")) {
            URL uRL = new URL("jar:" + this.jarLocation + "!/packs/pack" + n);
            JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
            inputStream = jarURLConnection.getInputStream();
        }
        return inputStream;
    }

    private String translatePath(String string) {
        string = this.vs.substitute(string, null);
        return string.replace('/', File.separatorChar);
    }
}

