/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallListener;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import net.n3.nanoxml.XMLElement;

public class InstallPanel
extends IzPanel
implements ActionListener,
InstallListener {
    private GridBagLayout layout = new GridBagLayout();
    private GridBagConstraints gbConstraints = new GridBagConstraints();
    protected JLabel tipLabel;
    protected JLabel opLabel;
    protected JProgressBar progressBar;
    private volatile boolean validated = false;

    public InstallPanel(InstallerFrame installerFrame, InstallData installData) {
        super(installerFrame, installData);
        this.setLayout(this.layout);
        this.tipLabel = new JLabel(installerFrame.langpack.getString("InstallPanel.tip"), installerFrame.icons.getImageIcon("tip"), 11);
        installerFrame.buildConstraints(this.gbConstraints, 0, 1, 2, 1, 1.0, 0.0);
        this.gbConstraints.fill = 0;
        this.gbConstraints.anchor = 18;
        this.layout.addLayoutComponent(this.tipLabel, this.gbConstraints);
        this.add(this.tipLabel);
        this.opLabel = new JLabel(" ", 11);
        installerFrame.buildConstraints(this.gbConstraints, 0, 2, 2, 1, 1.0, 0.0);
        this.gbConstraints.anchor = 16;
        this.layout.addLayoutComponent(this.opLabel, this.gbConstraints);
        this.add(this.opLabel);
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(true);
        this.progressBar.setString(installerFrame.langpack.getString("InstallPanel.begin"));
        this.progressBar.setValue(0);
        installerFrame.buildConstraints(this.gbConstraints, 0, 3, 2, 1, 1.0, 0.0);
        this.gbConstraints.anchor = 11;
        this.gbConstraints.fill = 2;
        this.layout.addLayoutComponent(this.progressBar, this.gbConstraints);
        this.add(this.progressBar);
    }

    public boolean isValidated() {
        return this.validated;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.parent.install(this);
    }

    public void startUnpack() {
        this.parent.blockGUI();
    }

    public void errorUnpack(String string) {
        this.opLabel.setText(string);
        this.idata.installSuccess = false;
        JOptionPane.showMessageDialog(this, string.toString(), this.parent.langpack.getString("installer.error"), 0);
    }

    public void stopUnpack() {
        this.parent.releaseGUI();
        this.parent.lockPrevButton();
        this.progressBar.setString(this.parent.langpack.getString("InstallPanel.finished"));
        this.progressBar.setEnabled(false);
        this.opLabel.setText(" ");
        this.opLabel.setEnabled(false);
        this.idata.installSuccess = true;
        this.idata.canClose = true;
        this.validated = true;
        if (this.idata.panels.indexOf(this) != this.idata.panels.size() - 1) {
            this.parent.unlockNextButton();
        }
    }

    public void progressUnpack(int n, String string) {
        this.progressBar.setValue(n + 1);
        this.opLabel.setText(string);
    }

    public void changeUnpack(int n, int n2, String string) {
        this.progressBar.setValue(0);
        this.progressBar.setMinimum(n);
        this.progressBar.setMaximum(n2);
        this.progressBar.setString(string);
    }

    public void panelActivate() {
        Dimension dimension = this.parent.getPanelsContainerSize();
        dimension.width -= dimension.width / 4;
        dimension.height = 150;
        this.setMinimumSize(dimension);
        this.setMaximumSize(dimension);
        this.setPreferredSize(dimension);
        this.parent.lockNextButton();
        this.parent.install(this);
    }

    public void runAutomated(XMLElement xMLElement) {
        this.parent.install(this);
        while (!this.validated) {
            Thread.yield();
        }
    }
}

