/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;

public class Debug {
    private static final boolean TRACE;
    private static final boolean STACKTRACE;
    public static boolean LOG;
    private static PrintWriter logFile;

    public static void trace(Object object) {
        if (TRACE) {
            System.out.println(object);
            if (STACKTRACE && object instanceof Throwable) {
                ((Throwable)object).printStackTrace();
            }
            System.out.flush();
        }
    }

    public static void error(Object object) {
        Debug.trace(object);
        System.err.println(object);
        System.err.flush();
        if (LOG && logFile == null) {
            Debug.createLogFile();
        }
        if (LOG && logFile != null && object != null) {
            logFile.print(object);
            if (object instanceof Throwable) {
                ((Throwable)object).printStackTrace(logFile);
            }
            logFile.flush();
        }
    }

    private static void createLogFile() {
        try {
            File file = new File(System.getProperty("user.dir"), ".log.txt");
            if (file.canWrite()) {
                if (file.exists()) {
                    file.delete();
                }
                FileWriter fileWriter = new FileWriter(file);
                logFile = new PrintWriter(fileWriter);
            }
        }
        catch (Throwable throwable) {
            System.err.println(throwable);
            System.err.flush();
        }
    }

    public static boolean tracing() {
        return TRACE;
    }

    static {
        boolean bl = false;
        try {
            bl = Boolean.getBoolean("STACKTRACE");
        }
        catch (Exception exception) {
            // empty catch block
        }
        STACKTRACE = bl;
        boolean bl2 = false;
        try {
            bl2 = STACKTRACE ? true : Boolean.getBoolean("TRACE");
        }
        catch (Exception exception) {
            // empty catch block
        }
        TRACE = bl2;
    }
}

