/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.ExecutableFile;
import com.izforge.izpack.util.Console;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.Os;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JOptionPane;

public class FileExecutor {
    private Collection files;

    private boolean stopThread(Thread thread, MonitorInputStream monitorInputStream) {
        monitorInputStream.doStop();
        long l = 1000L;
        try {
            thread.join(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!thread.isAlive()) {
            return true;
        }
        thread.interrupt();
        long l2 = 1000L;
        try {
            thread.join(l2);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return !thread.isAlive();
    }

    public FileExecutor(Collection collection) {
        this.files = collection;
    }

    public int executeCommand(String[] stringArray, String[] stringArray2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("executeCommand\n");
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                stringBuffer.append("\tparams: " + stringArray[n]);
                stringBuffer.append("\n");
                ++n;
            }
        }
        Process process = null;
        MonitorInputStream monitorInputStream = null;
        MonitorInputStream monitorInputStream2 = null;
        Thread thread = null;
        Thread thread2 = null;
        int n = -1;
        try {
            process = Runtime.getRuntime().exec(stringArray);
            boolean bl = false;
            if (bl) {
                Console console = new Console(process);
                stringArray2[0] = console.getOutputData();
                stringArray2[1] = console.getErrorData();
            } else {
                StringWriter stringWriter = new StringWriter();
                StringWriter stringWriter2 = new StringWriter();
                InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream());
                InputStreamReader inputStreamReader2 = new InputStreamReader(process.getErrorStream());
                monitorInputStream = new MonitorInputStream(inputStreamReader, stringWriter);
                monitorInputStream2 = new MonitorInputStream(inputStreamReader2, stringWriter2);
                thread = new Thread(monitorInputStream);
                thread2 = new Thread(monitorInputStream2);
                thread.setDaemon(true);
                thread2.setDaemon(true);
                thread.start();
                thread2.start();
                n = process.waitFor();
                if (thread != null) {
                    thread.join();
                }
                if (thread2 != null) {
                    thread2.join();
                }
                stringArray2[0] = stringWriter.toString();
                stringArray2[1] = stringWriter2.toString();
            }
            n = process.exitValue();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace(System.err);
            this.stopThread(thread, monitorInputStream);
            this.stopThread(thread2, monitorInputStream2);
            stringArray2[0] = "";
            stringArray2[1] = interruptedException.getMessage() + "\n";
            process.destroy();
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
            stringArray2[0] = "";
            stringArray2[1] = iOException.getMessage() + "\n";
        }
        return n;
    }

    public int executeFiles() {
        int n = 0;
        String[] stringArray = new String[2];
        String string = System.getProperty("path.separator");
        String string2 = System.getProperty("os.name").toLowerCase();
        String string3 = System.getProperty("user.name").equals("root") ? "a+x" : "u+x";
        Iterator iterator = this.files.iterator();
        while (n == 0 && iterator.hasNext()) {
            String[] stringArray2;
            boolean bl = true;
            ExecutableFile executableFile = (ExecutableFile)iterator.next();
            File file = new File(executableFile.path);
            Debug.trace("handeling executable file " + executableFile);
            if (string.equals(":") && (!string2.startsWith("mac") || string2.endsWith("x"))) {
                Debug.trace("making file executable (setting executable flag)");
                stringArray2 = new String[]{"/bin/chmod", string3, file.toString()};
                n = this.executeCommand(stringArray2, stringArray);
            }
            if (!(stringArray2 = executableFile.osList.iterator()).hasNext()) {
                Debug.trace("no os to install the file on!");
            }
            while (stringArray2.hasNext()) {
                Os os = (Os)stringArray2.next();
                Debug.trace("checking if os param on file " + os + " equals current os");
                if (os.matchCurrentSystem()) {
                    Debug.trace("match current os");
                    if (n != 0 || executableFile.executionStage != 0) continue;
                    ArrayList<String> arrayList = new ArrayList<String>();
                    if (0 == executableFile.type) {
                        arrayList.add(file.toString());
                    } else if (1 == executableFile.type && null == executableFile.mainClass) {
                        arrayList.add(System.getProperty("java.home") + "/bin/java");
                        arrayList.add("-jar");
                        arrayList.add(file.toString());
                    } else if (1 == executableFile.type && null != executableFile.mainClass) {
                        arrayList.add(System.getProperty("java.home") + "/bin/java");
                        arrayList.add("-cp=" + file.toString());
                        arrayList.add(executableFile.mainClass);
                    }
                    if (null != executableFile.argList && !executableFile.argList.isEmpty()) {
                        arrayList.addAll(executableFile.argList);
                    }
                    String[] stringArray3 = new String[arrayList.size()];
                    int n2 = 0;
                    while (n2 < arrayList.size()) {
                        stringArray3[n2] = (String)arrayList.get(n2);
                        ++n2;
                    }
                    n = this.executeCommand(stringArray3, stringArray);
                    if (n == 0) continue;
                    bl = false;
                    String string4 = stringArray[0] + "\n" + stringArray[1];
                    if (string4.length() == 1) {
                        string4 = new String("Failed to execute " + file.toString() + ".");
                    }
                    if (executableFile.onFailure == 0) {
                        JOptionPane.showMessageDialog(null, string4, "Installation error", 0);
                        continue;
                    }
                    if (executableFile.onFailure == 1) {
                        JOptionPane.showMessageDialog(null, string4, "Installation warning", 2);
                        n = 0;
                        continue;
                    }
                    if (JOptionPane.showConfirmDialog(null, string4 + "Would you like to proceed?", "Installation Warning", 0) != 0) continue;
                    n = 0;
                    continue;
                }
                Debug.trace("-no match with current os!");
            }
            if (executableFile.executionStage != 0 || !bl || !file.canWrite()) continue;
            file.delete();
        }
        return n;
    }

    private class MonitorInputStream
    implements Runnable {
        private BufferedReader reader;
        private BufferedWriter writer;
        private boolean shouldStop = false;

        public MonitorInputStream(Reader reader, Writer writer) {
            this.reader = new BufferedReader(reader);
            this.writer = new BufferedWriter(writer);
        }

        public void doStop() {
            this.shouldStop = true;
        }

        public void run() {
            try {
                String string;
                while ((string = this.reader.readLine()) != null) {
                    this.writer.write(string);
                    this.writer.newLine();
                    this.writer.flush();
                    if (!this.shouldStop) continue;
                    return;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.out);
            }
        }
    }
}

