/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import java.io.Serializable;

public class Os
implements Serializable {
    private String family;
    private String name;
    private String version;
    private String arch;

    public Os(String string, String string2, String string3, String string4) {
        this.family = string != null ? string.toLowerCase() : null;
        this.name = string2 != null ? string2.toLowerCase() : null;
        this.version = string3 != null ? string3.toLowerCase() : null;
        this.arch = string4 != null ? string4.toLowerCase() : null;
    }

    public boolean matchCurrentSystem() {
        boolean bl = true;
        String string = System.getProperty("os.name").toLowerCase();
        if (this.arch != null && this.arch.length() != 0) {
            bl = System.getProperty("os.arch").toLowerCase().equals(this.arch);
        }
        if (bl && this.version != null && this.version.length() != 0) {
            bl = System.getProperty("os.version").toLowerCase().equals(this.version);
        }
        if (bl && this.name != null && this.name.length() != 0) {
            bl = string.equals(this.name);
        }
        if (bl && this.family != null) {
            if (this.family.equals("windows")) {
                bl = string.indexOf("windows") > -1;
            } else if (this.family.equals("mac")) {
                bl = string.indexOf("mac") > -1 && !string.endsWith("x");
            } else if (this.family.equals("unix")) {
                String string2 = System.getProperty("path.separator");
                bl = string2.equals(":") && (!string.startsWith("mac") || string.endsWith("x"));
            }
        }
        return bl && (this.family != null || this.name != null || this.version != null || this.arch != null);
    }

    public void setFamily(String string) {
        this.family = string.toLowerCase();
    }

    public String getFamily() {
        return this.family;
    }

    public void setName(String string) {
        this.name = string.toLowerCase();
    }

    public String getName() {
        return this.name;
    }

    public void setVersion(String string) {
        this.version = string.toLowerCase();
    }

    public String getVersion() {
        return this.version;
    }

    public void setArch(String string) {
        this.arch = string.toLowerCase();
    }

    public String getArch() {
        return this.arch;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[Os ");
        stringBuffer.append(" family " + this.family);
        stringBuffer.append(" name " + this.name);
        stringBuffer.append(" version " + this.version);
        stringBuffer.append(" arch " + this.arch);
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }
}

