/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.StringTokenizer;

public class TargetFactory {
    public static final int WINDOWS = 0;
    public static final int MAC = 1;
    public static final int UNIX = 2;
    public static final int GENERIC = 3;
    public static final int STANDARD = 0;
    public static final int NT = 1;
    public static final int X = 2;
    public static final int X86 = 0;
    public static final int OTHER = 1;
    public static final String[] LIBRARY_EXTENSION = new String[]{"dll", "so", "", ""};
    public static final String[] CLASS_PREFIX = new String[]{"Win_", "Mac_", "UNIX_", ""};
    public static final String[] CLASS_FLAVOR_PREFIX = new String[]{"", "NT_", "X_"};
    public static final String[] CLASS_ARCHITECTURE_PREFIX = new String[]{"X86_", "U_"};
    public static final String[] INSTALL_PATH_FRAGMENT = new String[]{"Program Files" + File.separator, "/Applications" + File.separator, "/usr/local" + File.separator, File.separator + "apps" + File.separator};
    public static final String[][] INSTALL_PATH_RESOURCE_KEY = new String[][]{{"TargetPanel.dir.windows", "TargetPanel.dir.windows", ""}, {"TargetPanel.dir.mac", "", "TargetPanel.dir.macosx"}, {"TargetPanel.dir.unix", "", ""}, {"TargetPanel.dir", "", ""}};
    private static final String VERSION_DELIMITER = ".-";
    private static final String CLASS_EXTENSION = ".class";
    private static TargetFactory me = null;
    private int os = -1;
    private int osFlavor = -1;
    private int architecture = -1;
    private String version = "";
    private String osName = System.getProperty("os.name").toLowerCase();

    private TargetFactory() {
        this.version = System.getProperty("os.version");
        if (this.osName.indexOf("windows") > -1) {
            this.os = 0;
            this.osFlavor = 0;
            this.architecture = 0;
            if (this.osName.indexOf("nt") > -1) {
                this.osFlavor = 1;
            } else if (this.osName.indexOf("2000") > -1) {
                this.osFlavor = 1;
            } else if (this.osName.indexOf("xp") > -1) {
                this.osFlavor = 1;
            }
        } else if (this.osName.indexOf("mac") > -1) {
            this.os = 1;
            this.osFlavor = 0;
            this.architecture = 1;
            if (this.osName.indexOf("macosx") > -1) {
                this.osFlavor = 2;
            }
        } else {
            this.os = 2;
            this.osFlavor = 0;
            this.architecture = 1;
            if (this.osName.indexOf("x86") > -1) {
                this.architecture = 0;
            }
        }
    }

    public static TargetFactory getInstance() {
        if (me == null) {
            me = new TargetFactory();
        }
        return me;
    }

    public Object makeObject(String string) throws Exception {
        int n = string.lastIndexOf(46) + 1;
        String string2 = string.substring(0, n);
        String string3 = string.substring(n, string.length());
        try {
            String string4 = string2 + CLASS_PREFIX[this.os] + CLASS_FLAVOR_PREFIX[this.osFlavor] + string3;
            Class<?> clazz = Class.forName(string4);
            return clazz.newInstance();
        }
        catch (Throwable throwable) {
            try {
                Class<?> clazz = Class.forName(string2 + CLASS_PREFIX[this.os] + string3);
                return clazz.newInstance();
            }
            catch (Throwable throwable2) {
                try {
                    String string5 = string;
                    Class<?> clazz = Class.forName(string5);
                    return clazz.newInstance();
                }
                catch (Throwable throwable3) {
                    throw new Exception("can not instantiate class " + string);
                }
            }
        }
    }

    public boolean versionIsHigher(String string) throws Exception {
        StringTokenizer stringTokenizer = new StringTokenizer(this.version, VERSION_DELIMITER);
        StringTokenizer stringTokenizer2 = new StringTokenizer(string, VERSION_DELIMITER);
        while (stringTokenizer.hasMoreTokens() && stringTokenizer2.hasMoreTokens()) {
            int n;
            int n2;
            try {
                n2 = Integer.parseInt(stringTokenizer.nextToken());
                n = Integer.parseInt(stringTokenizer2.nextToken());
            }
            catch (Throwable throwable) {
                throw new Exception("error in version string");
            }
            if (n > n2) {
                return true;
            }
            if (n2 <= n) continue;
            return false;
        }
        return false;
    }

    public int getOS() {
        return this.os;
    }

    public int getOSFlavor() {
        return this.osFlavor;
    }

    public int getArchitecture() {
        return this.architecture;
    }

    public String getNativeLibraryExtension() {
        return LIBRARY_EXTENSION[this.os];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDefaultInstallPath(String string) {
        Object object;
        String string2 = null;
        InputStream inputStream = null;
        String string3 = "/res/" + INSTALL_PATH_RESOURCE_KEY[3][0];
        inputStream = this.getClass().getResourceAsStream("/res/" + INSTALL_PATH_RESOURCE_KEY[this.os][this.osFlavor]);
        if (inputStream == null) {
            object = this.osName.replace(' ', '_');
            object = string3 + ((String)object).toLowerCase();
            inputStream = this.getClass().getResourceAsStream((String)object);
        }
        if (inputStream == null) {
            inputStream = this.getClass().getResourceAsStream(string3);
        }
        if (inputStream != null) {
            object = null;
            BufferedReader bufferedReader = null;
            String string4 = null;
            try {
                object = new InputStreamReader(inputStream);
                bufferedReader = new BufferedReader((Reader)object);
                string4 = bufferedReader.readLine();
                while (string4 != null) {
                    if (!(string4 = string4.trim()).equals("")) break;
                    string4 = bufferedReader.readLine();
                }
                string2 = string4;
                return string2;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                try {
                    bufferedReader.close();
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        if (string2 == null || string2.equals("")) {
            string2 = "";
            if (this.os == 0) {
                object = System.getProperty("user.home");
                string2 = ((String)object).substring(0, ((String)object).indexOf(File.separatorChar) + 1);
            }
            string2 = string2 + INSTALL_PATH_FRAGMENT[this.os] + string;
        }
        return string2;
    }
}

